/**
 * md2ld.js (Microdata to Linked Data)
 * 
 * Microdata から Linked Data (JSON-LD) を生成し head要素 に script[type="application/ld+json"] を追加します
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * @package md2ld.js
 * @since 1.0.0
 * @author Shimotsuki
 * @copyright Copyright (C) 2025 Shimotsuki
 * @license http://www.gnu.org/licenses/gpl-2.0.html GPL v2 or later
 * @link https://shimotsuki.wwwxyz.jp/
 */
new class{idCounter=1;constructor(){const t=this.generate();if(t){const e=document.createElement("script");e.type="application/ld+json",e.textContent=t,document.head.append(e),document.querySelectorAll("[itemscope], [itemtype], [itemid], [itemref], [itemprop]").forEach((t=>{t.removeAttribute("itemscope"),t.removeAttribute("itemtype"),t.removeAttribute("itemid"),t.removeAttribute("itemref"),t.removeAttribute("itemprop"),t.removeAttribute("data-ld-id")})),document.querySelectorAll("[itemprop]:is(link, meta)").forEach((t=>{t.remove()}))}}generate(){const t={};if(document.querySelectorAll("[itemscope][itemtype]:not([itemprop])").forEach((e=>{this.processEntity(e,t)})),0===Object.keys(t).length)return null;const e={"@context":"https://schema.org","@graph":this.buildJsonLdGraph(t)};return JSON.stringify(e,null,2)}processEntity(t,e){const r=this.getEntityId(t);return e[r]||(e[r]={id:r,type:t.getAttribute("itemtype"),properties:this.collectProperties(t,e)}),r}getEntityId(t){if(t.hasAttribute("itemid"))return t.getAttribute("itemid");let e=t.dataset.ldId;return e||(e="#ld"+String(this.idCounter++).padStart(2,"0"),t.dataset.ldId=e),e}collectProperties(t,e){const r={};return this.recursivelyCollectProperties(t.children,t,e,r),r}recursivelyCollectProperties(t,e,r,i){for(const o of t){if(o.nodeType!==Node.ELEMENT_NODE)continue;const t=o.hasAttribute("itemprop"),n=o.hasAttribute("itemscope");if(t){if(n){const t=o.getAttribute("itemprop").split(/\s+/).filter((t=>t)),e=this.getPropertyValue(o,r);null!==e&&t.forEach((t=>{i[t]=i[t]||[],i[t].push(e)}));continue}{const t=o.getAttribute("itemprop").split(/\s+/).filter((t=>t)),n=this.getPropertyValue(o,r);null!==n&&t.forEach((t=>{i[t]=i[t]||[],i[t].push(n)})),this.recursivelyCollectProperties(o.children,e,r,i);continue}}n||this.recursivelyCollectProperties(o.children,e,r,i)}}getPropertyValue(t,e){const r=t.tagName.toLowerCase();if(t.hasAttribute("itemscope")){return{value:this.processEntity(t,e),is_reference:!0}}let i=null;if("meta"===r?i=t.getAttribute("content"):"audio"===r||"embed"===r||"iframe"===r||"img"===r||"source"===r||"track"===r||"video"===r?i=t.getAttribute("src"):"a"===r||"area"===r||"link"===r?i=t.getAttribute("href"):"object"===r?i=t.getAttribute("data"):"data"===r||"meter"===r?i=t.getAttribute("value"):"time"===r&&(i=t.getAttribute("datetime")),null!==i)return{value:i,is_reference:!1};const o=this.collectTextContent(t);return o?{value:o,is_reference:!1}:null}collectTextContent(t){let e=[];for(const r of t.childNodes)if(r.nodeType!==Node.TEXT_NODE){if(r.nodeType===Node.ELEMENT_NODE){if(!r.hasAttribute("itemscope"))continue;if("img"===r.tagName.toLowerCase()){const t=r.getAttribute("alt")||"";t&&e.push(t);continue}const t=this.collectTextContent(r);t&&e.push(t)}}else{const t=r.textContent.trim();0<t.length&&e.push(t)}return e.join(" ").replace(/\s+/g," ").trim()}collectTextContent(t){let e=[];for(const r of t.childNodes)if(r.nodeType!==Node.TEXT_NODE){if(r.nodeType===Node.ELEMENT_NODE){if("img"===r.tagName.toLowerCase()){const t=r.getAttribute("alt")||"";t&&e.push(t.trim());continue}if(!r.hasAttribute("itemprop"))continue;const t=this.collectTextContent(r);t&&e.push(t)}}else{const t=r.textContent.trim();0<t.length&&e.push(t)}return e.join(" ").replace(/\s+/g," ").trim()}buildJsonLdGraph(t){let e=[];for(const r in t){const i=t[r];let o={};if(i.id&&(o["@id"]=i.id),i.type&&(i.type.startsWith("https://schema.org/")?o["@type"]=i.type.substring(19):o["@type"]=i.type),i.properties)for(const t in i.properties){const e=i.properties[t];let r=[];e.forEach((t=>{void 0!==t.value&&null!==t.value&&(t.is_reference?r.push({"@id":t.value}):r.push(t.value))})),1===r.length?o[t]=r[0]:1<r.length&&(o[t]=r)}e.push(o)}return e}};
